/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSMansionConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MansionPieces;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MansionStructurePiece;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3614;
import net.minecraft.class_3790;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6624;
import net.minecraft.class_6834;
import net.minecraft.class_6880;
import net.minecraft.class_7059;

public class MansionStructure<C extends RSMansionConfig>
extends AbstractBaseStructure<C> {
    public MansionStructure(Codec<C> codec) {
        super(codec, MansionStructure::isMansionFeatureChunk, MansionStructure::generateMansionPieces, MansionStructure::afterPlace);
    }

    protected static <CC extends RSMansionConfig> boolean isMansionFeatureChunk(class_6834.class_6835<CC> context) {
        class_1923 chunkPos = context.comp_309();
        RSMansionConfig config = (RSMansionConfig)context.comp_310();
        if (!(context.comp_307() instanceof class_1973)) {
            for (int curChunkX = chunkPos.field_9181 - config.biomeRadius; curChunkX <= chunkPos.field_9181 + config.biomeRadius; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - config.biomeRadius; curChunkZ <= chunkPos.field_9180 + config.biomeRadius; ++curChunkZ) {
                    int yValue = context.comp_306().method_20402(curChunkX << 4, curChunkZ << 4, class_2902.class_2903.field_13194, context.comp_311());
                    class_6880 biome = context.comp_307().method_38109(curChunkX << 2, yValue >> 2, curChunkZ << 2, context.comp_306().method_38276());
                    if (context.comp_312().test(biome)) continue;
                    return false;
                }
            }
        }
        for (class_5321<class_7059> structureSetToAvoid : config.structureSetToAvoid) {
            if (!context.comp_306().method_41053(structureSetToAvoid, context.comp_308(), chunkPos.field_9181, chunkPos.field_9180, config.structureAvoidRadius)) continue;
            return false;
        }
        return true;
    }

    public static <CC extends RSMansionConfig> Optional<class_6622<CC>> generateMansionPieces(class_6834.class_6835<CC> context) {
        RSMansionConfig config = (RSMansionConfig)context.comp_310();
        class_1923 chunkPos = context.comp_309();
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
        class_2470 blockRotation = class_2470.method_16548((Random)random);
        int xOffset = 5;
        int zOffset = 5;
        if (blockRotation == class_2470.field_11463) {
            xOffset = -5;
        } else if (blockRotation == class_2470.field_11464) {
            xOffset = -5;
            zOffset = -5;
        } else if (blockRotation == class_2470.field_11465) {
            zOffset = -5;
        }
        int centerX = chunkPos.method_33940();
        int centerZ = chunkPos.method_33942();
        int firstHeight = context.comp_306().method_18028(centerX, centerZ, class_2902.class_2903.field_13194, context.comp_311());
        int secondHeight = context.comp_306().method_18028(centerX, centerZ + zOffset, class_2902.class_2903.field_13194, context.comp_311());
        int thirdHeight = context.comp_306().method_18028(centerX + xOffset, centerZ, class_2902.class_2903.field_13194, context.comp_311());
        int forthheight = context.comp_306().method_18028(centerX + xOffset, centerZ + zOffset, class_2902.class_2903.field_13194, context.comp_311());
        int finalheight = Math.min(Math.min(firstHeight, secondHeight), Math.min(thirdHeight, forthheight));
        if (finalheight <= context.comp_306().method_33730()) {
            return Optional.empty();
        }
        return Optional.of((structurePiecesBuilder, contextx) -> {
            class_2338 blockPos = new class_2338(chunkPos.method_33940(), finalheight + 1, chunkPos.method_33942());
            ArrayList<class_3443> list = new ArrayList<class_3443>();
            MansionPieces.createMansionLayout(context.comp_314(), context.comp_313(), blockPos, blockRotation, list, (Random)random, (RSMansionConfig)context.comp_310());
            list.forEach(piece -> {
                if (piece instanceof class_3790) {
                    class_3790 poolElementStructurePiece = (class_3790)piece;
                    structurePiecesBuilder.method_35462((class_3443)new MansionStructurePiece(poolElementStructurePiece, config.mansionType, config.foundationBlock, config.pillarOnlyToLand));
                } else {
                    structurePiecesBuilder.method_35462(piece);
                }
            });
        });
    }

    private static void afterPlace(class_5281 level, class_5138 structureFeatureManager, class_2794 chunkGenerator, Random random, class_3341 boundingBox, class_1923 chunkPos, class_6624 piecesContainer) {
        Object e;
        if (!piecesContainer.method_38708() && (e = piecesContainer.comp_132().get(0)) instanceof MansionStructurePiece) {
            MansionStructurePiece mansionStructurePiece = (MansionStructurePiece)((Object)e);
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            class_3341 box = piecesContainer.method_38712();
            int structureBottomY = box.method_35416();
            int terrainY = Integer.MIN_VALUE;
            for (int x = box.method_35415(); x <= box.method_35418(); ++x) {
                block1: for (int z = box.method_35417(); z <= box.method_35420(); ++z) {
                    if (chunkPos.field_9181 != x >> 4 || chunkPos.field_9180 != z >> 4) continue;
                    mutableBlockPos.method_10103(x, structureBottomY, z);
                    if (mansionStructurePiece.pillarOnlyToLand && (terrainY = GeneralUtils.getFirstLandYFromPos((class_4538)level, mutableBlockPos.method_10074())) <= chunkGenerator.method_33730() || level.method_22347((class_2338)mutableBlockPos) || !box.method_14662((class_2382)mutableBlockPos) || !piecesContainer.method_38710((class_2338)mutableBlockPos)) continue;
                    for (int currentY = structureBottomY - 1; !(currentY <= chunkGenerator.method_33730() || mansionStructurePiece.pillarOnlyToLand && currentY <= terrainY); --currentY) {
                        class_2338 blockPos2 = new class_2338(x, currentY, z);
                        class_3614 material = level.method_8320(blockPos2).method_26207();
                        if (!level.method_22347(blockPos2) && !material.method_15797() && material != class_3614.field_15956 && material != class_3614.field_26708 && material != class_3614.field_15926) continue block1;
                        level.method_8652(blockPos2, mansionStructurePiece.foundationBlock, 2);
                    }
                }
            }
        }
    }
}

